<?php
//namespace App\Service\Common; //TODO 根据需要自己加命名空间，以实现让框架自动加载
/**
 * 甘草医生开放平台基础Api
 * <p>【注意】建议php7.4.9及其以上环境，以下的版本请自行测试，不保证稳定。</p>
 * <p>【注意】找到 TODO 的注释条目，根据自己使用的信息进行修改，否则生产环境无法正常工作。</p>
 * @author LiJian
 * @version 20240826
 * @see https://apidoc.igancao.com/home/api-standard.html
 * @example
 * <p>
 *     $sPkg = 'igc_base.example.template';
 *     $sCls = 'GET_USER_INFO';
 *     $aParam = ['name'=>'王小明', 'age'=>43];
 *     $sRet = GcOpenApi::o()->execApi($sPkg, $sCls, $aParam);
 *     print_r($sRet);
 * </p>s
 */
class GcOpenApi{
    /**
     * 调用者客户端信息
     */
    const USER_AGENT = 'gancao-openapi-dev/0.0.1 (.....)'; //TODO: 此处修改填写您的程序识别信息
    /**
     * api网关地址
     * @var string
     */
    static private $sUrl = ''; //在构造函数中初始化
    /**
     * 账户 access key
     * @var string
     */
    static private $sAK = ''; //在构造函数中初始化
    /**
     * 秘钥 secret key
     * @var string
     */
    static private $sSK = ''; //在构造函数中初始化
    /**
     * 延迟静态绑定：对象引用缓存池
     * @var object
     */
    protected static $oInstance = null;
    /**
     * 获取模块静态对象引用
     * @return static
     * <li>返回模块对象</li>
     */
    public static function o(...$args) {
        if (isset(self::$oInstance[static::class])) {
            return self::$oInstance[static::class];
        }
        return self::$oInstance[static::class] = new static(...$args);
    }
    /**
     * 构造函数
     */
	public function __construct() {
        //判断是生产环境还是测试环境
        if (true){ //TODO:此处修改修改（判断你的本地环境）
            //测试环境地址
            self::$sUrl = 'http://dev-gapis-base.igancao.com/oapi';
            self::$sAK ='OU022B11I095379K7'; //access key
            self::$sSK ='46cb91b0f20c3e19'; //secret key
        }else{ //生产环境地址
            self::$sUrl = 'https://oapi.igancao.com';
            self::$sAK =''; //TODO: access key
            self::$sSK =''; //TODO: secret key
        }
	}

    /**
     * 请求api接口
     * @param string $sPkg 包路径
     * @param string $Cls 接口名称
     * @param array $aInParam 入参
     * <p>参考接口文档，传入数组</p>
     * @return array
     * <p>['state'=>'1成功，0通信失败，-1解密失败', 'msg'=>'状态', 'body'=>[接口返回数组对象], 'response'=>'失败的时候']</p>
     */
    public function execApi(string $sPkg, string $Cls, array $aInParam=[]): array{
        $aInParam['package'] = $sPkg;
        $aInParam['class'] = $Cls;
        //调试时，第二个参数为true，开启调试模式
        return $this->_transmission($aInParam);
    }
    /**
     * 数据接口传输层
     * @param array $aData 需要发送的数组对象
     * @param boolean $bDebug 临时开启一次调试模式
     * @return array
     * <p>['state'=>'1成功，0通信失败，-1解密失败', 'msg'=>'状态', 'body'=>[接口返回数组对象], 'response'=>'失败的时候']</p>
     */
    private function _transmission(array $aData, bool $bDebug=false): array{
        $iTimestamp = time();
        $sData = json_encode($aData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); //数组转换成json对象
        $sNoise = self::randStr(8); //随机数

        $sSignature = sha1($sData . $iTimestamp . $sNoise . self::$sSK);
        $sDataAes = self::encrypt($sData, self::$sSK); //加密传输内容
        $ch = curl_init();//初始化curl
        $aHeader = array();
        $aHeader[] = 'Connection: close';
        $aHeader[] = 'Content-Type: application/json; charset=utf-8';
        $aHeader[] = 'Content-length: '. strlen($sDataAes);
        $aHeader[] = 'Cache-Control: no-cache';
        $aHeader[] = 'AK: '. self::$sAK;  //HTTP_ACCOUNT_KEY
        $aHeader[] = 'Signature: '. $sSignature;
        $aHeader[] = 'UTC-Timestamp: '. $iTimestamp;  //HTTP_UTC_TIMESTEMP
        $aHeader[] = 'NOISE: '. $sNoise; //HTTP_NOISE
        $aHeader[] = 'Expect:';
        if (false !== strpos(self::$sUrl, 'https:')){ //加入https专用请求头
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 跳过证书检查
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); // 从证书中检查SSL加密算法是否存在
        }
        curl_setopt($ch,CURLOPT_URL, self::$sUrl); //接口地址
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0); //强制协议为1.0
        curl_setopt($ch, CURLOPT_HTTPHEADER, $aHeader);//设置header
        curl_setopt($ch, CURLOPT_USERAGENT, self::USER_AGENT);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);//将结果保存成字符串
        curl_setopt($ch, CURLOPT_POST, true);//post提交方式
        curl_setopt($ch, CURLOPT_ENCODING ,'gzip'); //加入gzip解析
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 ); //php版本5.3及以上，可关闭IPV6，只使用IPV4
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3 ); //php版本5.2.3及以上，连接超时时间(秒)
        curl_setopt($ch, CURLOPT_TIMEOUT, 10 ); //运行超时(秒)
        curl_setopt($ch, CURLOPT_POSTFIELDS, $sDataAes); //送出post数据
        curl_setopt($ch, CURLOPT_HEADER, true); //获取头信息
        $iStart = microtime(true); //记录通信开始时间
        $sResponseRaw = curl_exec($ch);//运行curl
        $aCurlInfo = curl_getinfo($ch);//获取状态信息
        $sResponseRaw = substr($sResponseRaw, strpos($sResponseRaw, "\r\n\r\n")+4); //保存最后一次收到的数据
        $sTmp = self::decrypt($sResponseRaw, self::$sSK);//解密传输内容

        if (!empty($sTmp)){ //解码成功
            $sResponse = $sTmp;
            $bDecodeState = true;
        }else{ //解码失败
            $sResponse = $sResponseRaw;
            $bDecodeState = false;
        }
        if (200 === $aCurlInfo['http_code']){ //通信成功
            if ($bDebug){ //打印调试信息
                $aTmp = [
                    '<pre>', 'Interface url: ', self::$sUrl, PHP_EOL,
                    'Transmission time(ms): ', sprintf('%.4f', (microtime(true) - $iStart)*1000), PHP_EOL,
                    'Header:', PHP_EOL, "\t", implode(PHP_EOL ."\t", $aHeader), PHP_EOL,
                    'Send data:', PHP_EOL, self::jsonFormat($sData), PHP_EOL,
                    'Send data(AES):', PHP_EOL, "\t", $sDataAes, PHP_EOL,
                    str_pad('', 20, '-'), PHP_EOL,
                    'Receive data:', PHP_EOL, self::jsonFormat($sResponse), PHP_EOL,
                    'Receive data(AES):', PHP_EOL, "\t", $sResponseRaw, PHP_EOL,
                    '</pre>'
                ];
                echo implode($aTmp);
                unset($aTmp);$aTmp=null;
            }
            curl_close($ch);
            unset($ch, $aCurlInfo);

            $aOutBuf = json_decode($sResponse, true);
            if ($bDecodeState){
                return ['state'=>1, 'msg'=>'成功', 'body'=>json_decode($sResponse, true)];
            }else{
                return ['state'=>-1, 'msg'=>'解密失败', 'response'=>$sResponse];
            }
        }else{ //通信失败
            if ($bDebug){ //打印调试信息
                $aTmp = [
                    '<pre>', 'Interface url: ', self::$sUrl, PHP_EOL,
                    'Transmission time(ms): ', sprintf('%.4f', (microtime(true) - $iStart)*1000), PHP_EOL,
                    'Send data:', PHP_EOL, self::jsonFormat($sData), PHP_EOL,
                    'Send data(AES):', $sDataAes, PHP_EOL,
                    'Receive data:', PHP_EOL, self::jsonFormat($sResponse), PHP_EOL,
                    'Receive data(AES):', $sResponseRaw, PHP_EOL,
                    '</pre>', PHP_EOL
                ];
                echo implode($aTmp);
                unset($aTmp);$aTmp=null;
            }
            return ['state'=>0, 'msg'=>'通信失败', 'response'=>$sResponse]; //通信失败
        }
    }
    /**
     * 加密处理
     * @param string $string 需要加密的字符串
     * @param string $key 密钥
     * <li>注意：key只有前16位参与加密</li>
     * @return string
     * <p>加密后的数据，空表示解密失败</p>
     */
    static private function encrypt(string $string, string $key): string{
        // openssl_encrypt 加密不同Mcrypt，对秘钥长度要求，超出16加密结果不变
        $sOutBuf = openssl_encrypt($string, 'AES-128-ECB', $key, OPENSSL_RAW_DATA);
        if (false !== $sOutBuf){
            return base64_encode($sOutBuf);
        }else{
            return '';
        }
    }
    /**
     * 解密处理
     * @param string $string 需要解密的字符串(base64)
     * @param string $key 密钥
     * <li>注意：key只有前16位参与解密</li>
     * @return string
     * <p>解密后的数据，空表示解密失败</p>
     */
    static private function decrypt(string $string, string $key):string{
        $sOutBuf = openssl_decrypt(base64_decode($string), 'AES-128-ECB', $key, OPENSSL_RAW_DATA);
        if (false !== $sOutBuf){
            return $sOutBuf;
        }else{
            return '';
        }
    }
    /**
     * 获取随机字符串
     * <p>【说明】生成规则：首字母不为0，相邻字符不相同。</p>
     * @param int $iLength 输出长度
     * <p>默认长度4</p>
     * <p>默认为:ABCDEFGHIJKLMNPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890</p>
     * @return string
     */
    static private function randStr(int $iLength = 4): string{
        $sChars = 'ABCDEFGHIJKLMNPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
        $sChars = str_shuffle($sChars); //随机性增加
        $iCharsEndSite = (strlen($sChars) - 1); //字符串终止位
        $aOutBuf = []; //输出缓存
        $iOutBufLen = 0; //临时计数器
        //生成首字母(首字母不可以为0前导)
        while (true){
            $sChar = $sChars[rand(0, $iCharsEndSite)];
            if ('0' !== $sChar){
                $aOutBuf[] = $sChar;
                break;
            }
        }
        //生成后续字母
        while($iOutBufLen < ($iLength-1)){
            $r = $sChars[mt_rand(0, $iCharsEndSite)]; //取随机字母
            if ($r != end($aOutBuf)) { //相邻字母不相同则保存
                $aOutBuf[] = $r;
                $iOutBufLen++;
            }
        }
        return implode($aOutBuf);
    }
    /**
     * Json数据格式化
     * @param String $data   数据
     * @param String|null $indent 缩进字符，默认4个空格
     * @return string
     */
    static private function jsonFormat(string $data, string $indent=null): string{
        // 缩进处理
        $aOutBuf = array();
        $pos = 0;
        $length = strlen($data);
        $indent = $indent ?? '    ';
        $newline = "\n";
        $prevchar = '';
        $outofquotes = true;
        for($i=0; $i<=$length; $i++){
            $char = substr($data, $i, 1);
            if($char=='"' && $prevchar!='\\'){
                $outofquotes = !$outofquotes;
            }elseif(($char=='}' || $char==']') && $outofquotes){
                $aOutBuf[] = $newline;
                $pos --;
                for($j=0; $j<$pos; $j++){
                    $aOutBuf[] = $indent;
                }
            }
            $aOutBuf[] = $char;
            if(($char==',' || $char=='{' || $char=='[') && $outofquotes){
                $aOutBuf[] = $newline;
                if($char=='{' || $char=='['){
                    $pos ++;
                }
                for($j=0; $j<$pos; $j++){
                    $aOutBuf[] = $indent;
                }
            }
            $prevchar = $char;
        }
        return implode($aOutBuf);
    }
}