package cn.igancao;

import com.google.gson.Gson;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.*;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class GcOpenApi {
    private static final String USER_AGENT = "gancao-openapi-dev/0.0.1 (.....)"; // TODO: 修改填写您的程序识别信息

    private static String sUrl;
    private static String sAK;
    private static String sSK;

    private static GcOpenApi instance;

    public static GcOpenApi getInstance() {
        if (instance == null) {
            instance = new GcOpenApi();
        }
        return instance;
    }

    private GcOpenApi() {
        if (true) { // TODO: 修改修改
            // 测试环境地址
            sUrl = "http://dev-gapis-base.igancao.com/oapi";
            sAK = "OU022B11I095379K7"; // access key
            sSK = "46cb91b0f20c3e19"; // secret key
        } else { // 生产环境地址
            sUrl = "https://oapi.igancao.com";
            sAK = "OU022B11I095379K7"; // TODO: access key
            sSK = "46cb91b0f20c3e19"; // TODO: secret key
        }
    }

    public Map<String, Object> execApi(String pkg, String cls, Map<String, Object> aInParam) {
        aInParam.put("package", pkg);
        aInParam.put("class", cls);
        return transmission(aInParam);
    }

    private Map<String, Object> transmission(Map<String, Object> aData) {
        long iTimestamp = System.currentTimeMillis() / 1000;
        String sData = new Gson().toJson(aData);
        String sNoise = randStr(8);

        String sSignature = sha1(sData + iTimestamp + sNoise + sSK);
        String sDataAes = encrypt(sData, sSK);
        try {
            URL url = new URL(sUrl);
            HttpURLConnection conn;
            if (sUrl.startsWith("https")) {
                trustAllHosts(); // 信任所有证书
                HttpsURLConnection httpsConn = (HttpsURLConnection) url.openConnection();
                httpsConn.setHostnameVerifier((hostname, session) -> true);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection) url.openConnection();
            }
            conn.setRequestMethod("POST");
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setRequestProperty("Connection", "close");
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestProperty("Content-Length", String.valueOf(sDataAes.length()));
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("AK", sAK);
            conn.setRequestProperty("Signature", sSignature);
            conn.setRequestProperty("UTC-Timestamp", String.valueOf(iTimestamp));
            conn.setRequestProperty("NOISE", sNoise);
            conn.setDoOutput(true);

            try (OutputStream os = conn.getOutputStream()) {
                os.write(sDataAes.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = conn.getResponseCode();
            StringBuilder response;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(),StandardCharsets.UTF_8))) {
                String inputLine;
                response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            String sResponseRaw = response.toString();
            String sTmp = decrypt(sResponseRaw, sSK);

            if (responseCode == 200) {
                Map<String, Object> aOutBuf = new Gson().fromJson(sTmp, Map.class);
                if (sTmp != null && !sTmp.isEmpty()) {
                    return createMap("state", 1, "msg", "成功", "body", aOutBuf);
                } else {
                    return createMap("state", -1, "msg", "解密失败", "response", sResponseRaw);
                }
            } else {
                return createMap("state", 0, "msg", "通信失败", "response", sResponseRaw);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return createMap("state", 0, "msg", "通信失败", "response", e.getMessage());
        }
    }

    private static Map<String, Object> createMap(Object... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid keys and values");
        }
        Map<String, Object> map = new HashMap<>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put((String) keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    private static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }
            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private static String encrypt(String strToEncrypt, String secret) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String decrypt(String strToDecrypt, String secret) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(Cipher.DECRYPT_MODE, secretKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)),StandardCharsets.UTF_8);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String sha1(String input) {
        try {
            MessageDigest mDigest = MessageDigest.getInstance("SHA-1");
            byte[] result = mDigest.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : result) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String randStr(int length) {
        String chars = "ABCDEFGHIJKLMNPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
        Random rand = new Random();
        StringBuilder sb = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            char c = chars.charAt(rand.nextInt(chars.length()));
            if (i == 0 && c == '0') {
                i--;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        GcOpenApi api = GcOpenApi.getInstance();
        Map<String, Object> params = new HashMap<>();
        params.put("name", "王小明");
        params.put("age", 43);
        Map<String, Object> result = api.execApi("igc_base.example.template", "GET_USER_INFO", params);
        System.out.println(new Gson().toJson(result));
    }
}
